# The Legend of Zelda: Oracle of Seasons

## Where is the settings page?

The [player settings page for this game](../player-settings) contains most of the options you need to 
configure and export a config file.

## What does randomization do to this game?

Most acquirable pickups are shuffled among each other, following some logic to ensure the game ends up being completable.

Rare Maple drop is **not** randomized because it would not make much sense.

## What does another world's item look like in Oracle of Seasons?

Items belonging to other worlds use an easily recognizable Archipelago sprite, which is blue if the item is unimportant, and red if it is a progression item.
When collecting it, the game will inform you that you just sent an item to another player, and you can check on the client window to see which item was actually sent.

## Frequently Asked Questions

**What does medium / hard logic expects from me?**

> - **Casual logic** only expects what you are forced to know when doing a casual playthrough of the game
> - **Medium logic** expects you to have a complete knowledge of the game, but nothing execution-heavy will be required (no tricks or glitches)
> - **Hard logic** expects you to use glitches and perform tricks such as bomb jumps
> - **Hell logic** expects you to use really hard glitches such as H&S skip. Rooster adventure is in logic to access different location, but not to skip the barrier
> 
> A [document](https://docs.google.com/document/d/1IVYvvZS6NuTDoeWJlbFA5AW2Lj-nIaweRJkKuq7ncqc/) was built by the community to explain the breakdown between those logic levels more in detail. 

**Is there a tracker for this game?**

> Yes, Seto and OmegaZeron have built a Poptracker pack which can be downloaded [here](https://github.com/OmegaZeron/Oracle-of-Seasons-AP-Poptracker-Pack/releases/latest).

**Do I need to use Bizhawk?**

> If you are playing on a multiworld with more that one world, the answer is yes*.
> 
> In solo however, after patching your game, you can play it on any emulator or even original hardware. However, since you will be unable to connect, you will not have access to the hint system, a log of what you collected previously and a tracker, unless you switch emulator back to Bizhawk, bringing your save.
> 
> \*Zunawe also made a connector to use mgba instead. Instructions on how to download and use it are [here](https://discord.com/channels/731205301247803413/1192236871468711966/1193963132377374762) on the Archipelago Discord server

**I lost my shield, where do I get it back?**

**I don't have any of some consumable and no way to refill them, am I softlocked?**

> You can talk to Impa to refill your inventory of all consumables up to a certain amount (including any lost shield)
> If you want to refill more of your consumable, talk to a business deku to refill them entirely

**How can I warp to start?**

> You need to press A+B while the screen is fading to white into any menu (e.g. after pressing START or SELECT)

**How can I switch directly to a specific season instead of cycling all seasons everytime?**

> You can hold a diagonal on your directional pad right after having used the rod. This will switch directly to the season whose icon is placed in that direction next to the Rod of Seasons icon at the top of your screen. Timing is tight, but with some practice you will be able to save precious seconds.

**Can I do linked games using passwords from Oracle of Ages?**

> No, most linked features are disabled in this randomizer since it changes the world events and locations too heavily to be reasonable to maintain.
> However, linked secrets are an option that can be enabled

**How can I swap items with the inventory without going through the inventory menu ?**

> You can press B or A and START on the same frame to switch your B item with the first item of your inventory of the A item with the second item of your inventory. It is recommended to bind a macro if you want to use this feature.
> On Bizhawk, you can do that by going to the controller config, untick "Auto Tab" then binding the same control for both B and START (then again for A and START)